/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CompleteMultipartUploadRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").isBinary(false).build();
    private static final MarshallingInfo<String> UPLOADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("uploadId").isBinary(false).build();
    private static final MarshallingInfo<String> ARCHIVESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-archive-size").isBinary(false).build();
    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-sha256-tree-hash").isBinary(false).build();
    private static final CompleteMultipartUploadRequestModelMarshaller INSTANCE = new CompleteMultipartUploadRequestModelMarshaller();

    private CompleteMultipartUploadRequestModelMarshaller() {
    }

    public static CompleteMultipartUploadRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CompleteMultipartUploadRequest completeMultipartUploadRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)completeMultipartUploadRequest), (String)"completeMultipartUploadRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.uploadId(), UPLOADID_BINDING);
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.archiveSize(), ARCHIVESIZE_BINDING);
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.checksum(), CHECKSUM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

