/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVaultResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, DescribeVaultResponse> {
    private final String vaultARN;
    private final String vaultName;
    private final String creationDate;
    private final String lastInventoryDate;
    private final Long numberOfArchives;
    private final Long sizeInBytes;

    private DescribeVaultResponse(BuilderImpl builder) {
        super(builder);
        this.vaultARN = builder.vaultARN;
        this.vaultName = builder.vaultName;
        this.creationDate = builder.creationDate;
        this.lastInventoryDate = builder.lastInventoryDate;
        this.numberOfArchives = builder.numberOfArchives;
        this.sizeInBytes = builder.sizeInBytes;
    }

    public String vaultARN() {
        return this.vaultARN;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public String lastInventoryDate() {
        return this.lastInventoryDate;
    }

    public Long numberOfArchives() {
        return this.numberOfArchives;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastInventoryDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfArchives());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVaultResponse)) {
            return false;
        }
        DescribeVaultResponse other = (DescribeVaultResponse)((Object)obj);
        return Objects.equals(this.vaultARN(), other.vaultARN()) && Objects.equals(this.vaultName(), other.vaultName()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastInventoryDate(), other.lastInventoryDate()) && Objects.equals(this.numberOfArchives(), other.numberOfArchives()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVaultResponse").add("VaultARN", (Object)this.vaultARN()).add("VaultName", (Object)this.vaultName()).add("CreationDate", (Object)this.creationDate()).add("LastInventoryDate", (Object)this.lastInventoryDate()).add("NumberOfArchives", (Object)this.numberOfArchives()).add("SizeInBytes", (Object)this.sizeInBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VaultARN": {
                return Optional.of(clazz.cast(this.vaultARN()));
            }
            case "VaultName": {
                return Optional.of(clazz.cast(this.vaultName()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "LastInventoryDate": {
                return Optional.of(clazz.cast(this.lastInventoryDate()));
            }
            case "NumberOfArchives": {
                return Optional.of(clazz.cast(this.numberOfArchives()));
            }
            case "SizeInBytes": {
                return Optional.of(clazz.cast(this.sizeInBytes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String vaultARN;
        private String vaultName;
        private String creationDate;
        private String lastInventoryDate;
        private Long numberOfArchives;
        private Long sizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVaultResponse model) {
            this.vaultARN(model.vaultARN);
            this.vaultName(model.vaultName);
            this.creationDate(model.creationDate);
            this.lastInventoryDate(model.lastInventoryDate);
            this.numberOfArchives(model.numberOfArchives);
            this.sizeInBytes(model.sizeInBytes);
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final String getLastInventoryDate() {
            return this.lastInventoryDate;
        }

        @Override
        public final Builder lastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
            return this;
        }

        public final void setLastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
        }

        public final Long getNumberOfArchives() {
            return this.numberOfArchives;
        }

        @Override
        public final Builder numberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
            return this;
        }

        public final void setNumberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public DescribeVaultResponse build() {
            return new DescribeVaultResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, DescribeVaultResponse> {
        public Builder vaultARN(String var1);

        public Builder vaultName(String var1);

        public Builder creationDate(String var1);

        public Builder lastInventoryDate(String var1);

        public Builder numberOfArchives(Long var1);

        public Builder sizeInBytes(Long var1);
    }
}

