/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.UploadListElement;

public final class ListMultipartUploadsPaginator
implements SdkIterable<ListMultipartUploadsResponse> {
    private final GlacierClient client;
    private final ListMultipartUploadsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListMultipartUploadsPaginator(GlacierClient client, ListMultipartUploadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMultipartUploadsResponseFetcher();
    }

    public Iterator<ListMultipartUploadsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<UploadListElement> uploadsList() {
        Function<ListMultipartUploadsResponse, Iterator> getIterator = response -> response != null ? response.uploadsList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListMultipartUploadsResponseFetcher
    implements NextPageFetcher<ListMultipartUploadsResponse> {
        private ListMultipartUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultipartUploadsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListMultipartUploadsResponse nextPage(ListMultipartUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListMultipartUploadsPaginator.this.client.listMultipartUploads(ListMultipartUploadsPaginator.this.firstRequest);
            }
            return ListMultipartUploadsPaginator.this.client.listMultipartUploads((ListMultipartUploadsRequest)((Object)ListMultipartUploadsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

