/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription;
import software.amazon.awssdk.services.glacier.model.ProvisionedCapacityListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListProvisionedCapacityResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, ListProvisionedCapacityResponse> {
    private final List<ProvisionedCapacityDescription> provisionedCapacityList;

    private ListProvisionedCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedCapacityList = builder.provisionedCapacityList;
    }

    public List<ProvisionedCapacityDescription> provisionedCapacityList() {
        return this.provisionedCapacityList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedCapacityList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedCapacityResponse)) {
            return false;
        }
        ListProvisionedCapacityResponse other = (ListProvisionedCapacityResponse)((Object)obj);
        return Objects.equals(this.provisionedCapacityList(), other.provisionedCapacityList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.provisionedCapacityList() != null) {
            sb.append("ProvisionedCapacityList: ").append(this.provisionedCapacityList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedCapacityList": {
                return Optional.of(clazz.cast(this.provisionedCapacityList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private List<ProvisionedCapacityDescription> provisionedCapacityList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedCapacityResponse model) {
            this.provisionedCapacityList(model.provisionedCapacityList);
        }

        public final Collection<ProvisionedCapacityDescription.Builder> getProvisionedCapacityList() {
            return this.provisionedCapacityList != null ? (Collection)this.provisionedCapacityList.stream().map(ProvisionedCapacityDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedCapacityList(Collection<ProvisionedCapacityDescription> provisionedCapacityList) {
            this.provisionedCapacityList = ProvisionedCapacityListCopier.copy(provisionedCapacityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedCapacityList(ProvisionedCapacityDescription ... provisionedCapacityList) {
            this.provisionedCapacityList(Arrays.asList(provisionedCapacityList));
            return this;
        }

        public final void setProvisionedCapacityList(Collection<ProvisionedCapacityDescription.BuilderImpl> provisionedCapacityList) {
            this.provisionedCapacityList = ProvisionedCapacityListCopier.copyFromBuilder(provisionedCapacityList);
        }

        @Override
        public ListProvisionedCapacityResponse build() {
            return new ListProvisionedCapacityResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, ListProvisionedCapacityResponse> {
        public Builder provisionedCapacityList(Collection<ProvisionedCapacityDescription> var1);

        public Builder provisionedCapacityList(ProvisionedCapacityDescription ... var1);
    }
}

