/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.PartListCopier;
import software.amazon.awssdk.services.glacier.model.PartListElement;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPartsResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, ListPartsResponse> {
    private final String multipartUploadId;
    private final String vaultARN;
    private final String archiveDescription;
    private final Long partSizeInBytes;
    private final String creationDate;
    private final List<PartListElement> parts;
    private final String marker;

    private ListPartsResponse(BuilderImpl builder) {
        super(builder);
        this.multipartUploadId = builder.multipartUploadId;
        this.vaultARN = builder.vaultARN;
        this.archiveDescription = builder.archiveDescription;
        this.partSizeInBytes = builder.partSizeInBytes;
        this.creationDate = builder.creationDate;
        this.parts = builder.parts;
        this.marker = builder.marker;
    }

    public String multipartUploadId() {
        return this.multipartUploadId;
    }

    public String vaultARN() {
        return this.vaultARN;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public Long partSizeInBytes() {
        return this.partSizeInBytes;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public List<PartListElement> parts() {
        return this.parts;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.multipartUploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.partSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.parts());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsResponse)) {
            return false;
        }
        ListPartsResponse other = (ListPartsResponse)((Object)obj);
        return Objects.equals(this.multipartUploadId(), other.multipartUploadId()) && Objects.equals(this.vaultARN(), other.vaultARN()) && Objects.equals(this.archiveDescription(), other.archiveDescription()) && Objects.equals(this.partSizeInBytes(), other.partSizeInBytes()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.parts(), other.parts()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.multipartUploadId() != null) {
            sb.append("MultipartUploadId: ").append(this.multipartUploadId()).append(",");
        }
        if (this.vaultARN() != null) {
            sb.append("VaultARN: ").append(this.vaultARN()).append(",");
        }
        if (this.archiveDescription() != null) {
            sb.append("ArchiveDescription: ").append(this.archiveDescription()).append(",");
        }
        if (this.partSizeInBytes() != null) {
            sb.append("PartSizeInBytes: ").append(this.partSizeInBytes()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.parts() != null) {
            sb.append("Parts: ").append(this.parts()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultipartUploadId": {
                return Optional.of(clazz.cast(this.multipartUploadId()));
            }
            case "VaultARN": {
                return Optional.of(clazz.cast(this.vaultARN()));
            }
            case "ArchiveDescription": {
                return Optional.of(clazz.cast(this.archiveDescription()));
            }
            case "PartSizeInBytes": {
                return Optional.of(clazz.cast(this.partSizeInBytes()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "Parts": {
                return Optional.of(clazz.cast(this.parts()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String multipartUploadId;
        private String vaultARN;
        private String archiveDescription;
        private Long partSizeInBytes;
        private String creationDate;
        private List<PartListElement> parts;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsResponse model) {
            this.multipartUploadId(model.multipartUploadId);
            this.vaultARN(model.vaultARN);
            this.archiveDescription(model.archiveDescription);
            this.partSizeInBytes(model.partSizeInBytes);
            this.creationDate(model.creationDate);
            this.parts(model.parts);
            this.marker(model.marker);
        }

        public final String getMultipartUploadId() {
            return this.multipartUploadId;
        }

        @Override
        public final Builder multipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
            return this;
        }

        public final void setMultipartUploadId(String multipartUploadId) {
            this.multipartUploadId = multipartUploadId;
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public final Long getPartSizeInBytes() {
            return this.partSizeInBytes;
        }

        @Override
        public final Builder partSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
            return this;
        }

        public final void setPartSizeInBytes(Long partSizeInBytes) {
            this.partSizeInBytes = partSizeInBytes;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final Collection<PartListElement.Builder> getParts() {
            return this.parts != null ? (Collection)this.parts.stream().map(PartListElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parts(Collection<PartListElement> parts) {
            this.parts = PartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(PartListElement ... parts) {
            this.parts(Arrays.asList(parts));
            return this;
        }

        public final void setParts(Collection<PartListElement.BuilderImpl> parts) {
            this.parts = PartListCopier.copyFromBuilder(parts);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListPartsResponse build() {
            return new ListPartsResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, ListPartsResponse> {
        public Builder multipartUploadId(String var1);

        public Builder vaultARN(String var1);

        public Builder archiveDescription(String var1);

        public Builder partSizeInBytes(Long var1);

        public Builder creationDate(String var1);

        public Builder parts(Collection<PartListElement> var1);

        public Builder parts(PartListElement ... var1);

        public Builder marker(String var1);
    }
}

