/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetVaultLockResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, GetVaultLockResponse> {
    private final String policy;
    private final String state;
    private final String expirationDate;
    private final String creationDate;

    private GetVaultLockResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.state = builder.state;
        this.expirationDate = builder.expirationDate;
        this.creationDate = builder.creationDate;
    }

    public String policy() {
        return this.policy;
    }

    public String state() {
        return this.state;
    }

    public String expirationDate() {
        return this.expirationDate;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVaultLockResponse)) {
            return false;
        }
        GetVaultLockResponse other = (GetVaultLockResponse)((Object)obj);
        return Objects.equals(this.policy(), other.policy()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policy() != null) {
            sb.append("Policy: ").append(this.policy()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.expirationDate() != null) {
            sb.append("ExpirationDate: ").append(this.expirationDate()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.of(clazz.cast(this.policy()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.state()));
            }
            case "ExpirationDate": {
                return Optional.of(clazz.cast(this.expirationDate()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String policy;
        private String state;
        private String expirationDate;
        private String creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVaultLockResponse model) {
            this.policy(model.policy);
            this.state(model.state);
            this.expirationDate(model.expirationDate);
            this.creationDate(model.creationDate);
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public GetVaultLockResponse build() {
            return new GetVaultLockResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, GetVaultLockResponse> {
        public Builder policy(String var1);

        public Builder state(String var1);

        public Builder expirationDate(String var1);

        public Builder creationDate(String var1);
    }
}

