/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;

public final class ListVaultsPaginator
implements SdkIterable<ListVaultsResponse> {
    private final GlacierClient client;
    private final ListVaultsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListVaultsPaginator(GlacierClient client, ListVaultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVaultsResponseFetcher();
    }

    public Iterator<ListVaultsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DescribeVaultOutput> vaultList() {
        Function<ListVaultsResponse, Iterator> getIterator = response -> response != null ? response.vaultList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListVaultsResponseFetcher
    implements NextPageFetcher<ListVaultsResponse> {
        private ListVaultsResponseFetcher() {
        }

        public boolean hasNextPage(ListVaultsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListVaultsResponse nextPage(ListVaultsResponse previousPage) {
            if (previousPage == null) {
                return ListVaultsPaginator.this.client.listVaults(ListVaultsPaginator.this.firstRequest);
            }
            return ListVaultsPaginator.this.client.listVaults((ListVaultsRequest)((Object)ListVaultsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

