/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListVaultsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListVaultsRequest> {
    private final String accountId;
    private final String marker;
    private final String limit;

    private ListVaultsRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    public String accountId() {
        return this.accountId;
    }

    public String marker() {
        return this.marker;
    }

    public String limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVaultsRequest)) {
            return false;
        }
        ListVaultsRequest other = (ListVaultsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String marker;
        private String limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVaultsRequest model) {
            this.accountId(model.accountId);
            this.marker(model.marker);
            this.limit(model.limit);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(String limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(String limit) {
            this.limit = limit;
        }

        public ListVaultsRequest build() {
            return new ListVaultsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListVaultsRequest> {
        public Builder accountId(String var1);

        public Builder marker(String var1);

        public Builder limit(String var1);
    }
}

