/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetJobOutputResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetJobOutputResponse> {
    private final String checksum;
    private final Integer status;
    private final String contentRange;
    private final String acceptRanges;
    private final String contentType;
    private final String archiveDescription;

    private GetJobOutputResponse(BuilderImpl builder) {
        this.checksum = builder.checksum;
        this.status = builder.status;
        this.contentRange = builder.contentRange;
        this.acceptRanges = builder.acceptRanges;
        this.contentType = builder.contentType;
        this.archiveDescription = builder.archiveDescription;
    }

    public String checksum() {
        return this.checksum;
    }

    public Integer status() {
        return this.status;
    }

    public String contentRange() {
        return this.contentRange;
    }

    public String acceptRanges() {
        return this.acceptRanges;
    }

    public String contentType() {
        return this.contentType;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobOutputResponse)) {
            return false;
        }
        GetJobOutputResponse other = (GetJobOutputResponse)((Object)obj);
        return Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.contentRange(), other.contentRange()) && Objects.equals(this.acceptRanges(), other.acceptRanges()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.archiveDescription(), other.archiveDescription());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.contentRange() != null) {
            sb.append("ContentRange: ").append(this.contentRange()).append(",");
        }
        if (this.acceptRanges() != null) {
            sb.append("AcceptRanges: ").append(this.acceptRanges()).append(",");
        }
        if (this.contentType() != null) {
            sb.append("ContentType: ").append(this.contentType()).append(",");
        }
        if (this.archiveDescription() != null) {
            sb.append("ArchiveDescription: ").append(this.archiveDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "contentRange": {
                return Optional.of(clazz.cast(this.contentRange()));
            }
            case "acceptRanges": {
                return Optional.of(clazz.cast(this.acceptRanges()));
            }
            case "contentType": {
                return Optional.of(clazz.cast(this.contentType()));
            }
            case "archiveDescription": {
                return Optional.of(clazz.cast(this.archiveDescription()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String checksum;
        private Integer status;
        private String contentRange;
        private String acceptRanges;
        private String contentType;
        private String archiveDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobOutputResponse model) {
            this.checksum(model.checksum);
            this.status(model.status);
            this.contentRange(model.contentRange);
            this.acceptRanges(model.acceptRanges);
            this.contentType(model.contentType);
            this.archiveDescription(model.archiveDescription);
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getContentRange() {
            return this.contentRange;
        }

        @Override
        public final Builder contentRange(String contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        public final String getAcceptRanges() {
            return this.acceptRanges;
        }

        @Override
        public final Builder acceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
            return this;
        }

        public final void setAcceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public GetJobOutputResponse build() {
            return new GetJobOutputResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetJobOutputResponse> {
        public Builder checksum(String var1);

        public Builder status(Integer var1);

        public Builder contentRange(String var1);

        public Builder acceptRanges(String var1);

        public Builder contentType(String var1);

        public Builder archiveDescription(String var1);
    }
}

