/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.glacier.model.ActionCode;
import software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription;
import software.amazon.awssdk.services.glacier.model.StatusCode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeJobResponse> {
    private final String jobId;
    private final String jobDescription;
    private final String action;
    private final String archiveId;
    private final String vaultARN;
    private final String creationDate;
    private final Boolean completed;
    private final String statusCode;
    private final String statusMessage;
    private final Long archiveSizeInBytes;
    private final Long inventorySizeInBytes;
    private final String snsTopic;
    private final String completionDate;
    private final String sha256TreeHash;
    private final String archiveSHA256TreeHash;
    private final String retrievalByteRange;
    private final String tier;
    private final InventoryRetrievalJobDescription inventoryRetrievalParameters;

    private DescribeJobResponse(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobDescription = builder.jobDescription;
        this.action = builder.action;
        this.archiveId = builder.archiveId;
        this.vaultARN = builder.vaultARN;
        this.creationDate = builder.creationDate;
        this.completed = builder.completed;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.archiveSizeInBytes = builder.archiveSizeInBytes;
        this.inventorySizeInBytes = builder.inventorySizeInBytes;
        this.snsTopic = builder.snsTopic;
        this.completionDate = builder.completionDate;
        this.sha256TreeHash = builder.sha256TreeHash;
        this.archiveSHA256TreeHash = builder.archiveSHA256TreeHash;
        this.retrievalByteRange = builder.retrievalByteRange;
        this.tier = builder.tier;
        this.inventoryRetrievalParameters = builder.inventoryRetrievalParameters;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobDescription() {
        return this.jobDescription;
    }

    public ActionCode action() {
        return ActionCode.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public String archiveId() {
        return this.archiveId;
    }

    public String vaultARN() {
        return this.vaultARN;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public Boolean completed() {
        return this.completed;
    }

    public StatusCode statusCode() {
        return StatusCode.fromValue(this.statusCode);
    }

    public String statusCodeString() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Long archiveSizeInBytes() {
        return this.archiveSizeInBytes;
    }

    public Long inventorySizeInBytes() {
        return this.inventorySizeInBytes;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    public String completionDate() {
        return this.completionDate;
    }

    public String sha256TreeHash() {
        return this.sha256TreeHash;
    }

    public String archiveSHA256TreeHash() {
        return this.archiveSHA256TreeHash;
    }

    public String retrievalByteRange() {
        return this.retrievalByteRange;
    }

    public String tier() {
        return this.tier;
    }

    public InventoryRetrievalJobDescription inventoryRetrievalParameters() {
        return this.inventoryRetrievalParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completed());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventorySizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256TreeHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveSHA256TreeHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalByteRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventoryRetrievalParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobDescription(), other.jobDescription()) && Objects.equals(this.actionString(), other.actionString()) && Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.vaultARN(), other.vaultARN()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completed(), other.completed()) && Objects.equals(this.statusCodeString(), other.statusCodeString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.archiveSizeInBytes(), other.archiveSizeInBytes()) && Objects.equals(this.inventorySizeInBytes(), other.inventorySizeInBytes()) && Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.sha256TreeHash(), other.sha256TreeHash()) && Objects.equals(this.archiveSHA256TreeHash(), other.archiveSHA256TreeHash()) && Objects.equals(this.retrievalByteRange(), other.retrievalByteRange()) && Objects.equals(this.tier(), other.tier()) && Objects.equals(this.inventoryRetrievalParameters(), other.inventoryRetrievalParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.jobDescription() != null) {
            sb.append("JobDescription: ").append(this.jobDescription()).append(",");
        }
        if (this.actionString() != null) {
            sb.append("Action: ").append(this.actionString()).append(",");
        }
        if (this.archiveId() != null) {
            sb.append("ArchiveId: ").append(this.archiveId()).append(",");
        }
        if (this.vaultARN() != null) {
            sb.append("VaultARN: ").append(this.vaultARN()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.completed() != null) {
            sb.append("Completed: ").append(this.completed()).append(",");
        }
        if (this.statusCodeString() != null) {
            sb.append("StatusCode: ").append(this.statusCodeString()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.archiveSizeInBytes() != null) {
            sb.append("ArchiveSizeInBytes: ").append(this.archiveSizeInBytes()).append(",");
        }
        if (this.inventorySizeInBytes() != null) {
            sb.append("InventorySizeInBytes: ").append(this.inventorySizeInBytes()).append(",");
        }
        if (this.snsTopic() != null) {
            sb.append("SNSTopic: ").append(this.snsTopic()).append(",");
        }
        if (this.completionDate() != null) {
            sb.append("CompletionDate: ").append(this.completionDate()).append(",");
        }
        if (this.sha256TreeHash() != null) {
            sb.append("SHA256TreeHash: ").append(this.sha256TreeHash()).append(",");
        }
        if (this.archiveSHA256TreeHash() != null) {
            sb.append("ArchiveSHA256TreeHash: ").append(this.archiveSHA256TreeHash()).append(",");
        }
        if (this.retrievalByteRange() != null) {
            sb.append("RetrievalByteRange: ").append(this.retrievalByteRange()).append(",");
        }
        if (this.tier() != null) {
            sb.append("Tier: ").append(this.tier()).append(",");
        }
        if (this.inventoryRetrievalParameters() != null) {
            sb.append("InventoryRetrievalParameters: ").append(this.inventoryRetrievalParameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.of(clazz.cast(this.jobId()));
            }
            case "JobDescription": {
                return Optional.of(clazz.cast(this.jobDescription()));
            }
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "ArchiveId": {
                return Optional.of(clazz.cast(this.archiveId()));
            }
            case "VaultARN": {
                return Optional.of(clazz.cast(this.vaultARN()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "Completed": {
                return Optional.of(clazz.cast(this.completed()));
            }
            case "StatusCode": {
                return Optional.of(clazz.cast(this.statusCodeString()));
            }
            case "StatusMessage": {
                return Optional.of(clazz.cast(this.statusMessage()));
            }
            case "ArchiveSizeInBytes": {
                return Optional.of(clazz.cast(this.archiveSizeInBytes()));
            }
            case "InventorySizeInBytes": {
                return Optional.of(clazz.cast(this.inventorySizeInBytes()));
            }
            case "SNSTopic": {
                return Optional.of(clazz.cast(this.snsTopic()));
            }
            case "CompletionDate": {
                return Optional.of(clazz.cast(this.completionDate()));
            }
            case "SHA256TreeHash": {
                return Optional.of(clazz.cast(this.sha256TreeHash()));
            }
            case "ArchiveSHA256TreeHash": {
                return Optional.of(clazz.cast(this.archiveSHA256TreeHash()));
            }
            case "RetrievalByteRange": {
                return Optional.of(clazz.cast(this.retrievalByteRange()));
            }
            case "Tier": {
                return Optional.of(clazz.cast(this.tier()));
            }
            case "InventoryRetrievalParameters": {
                return Optional.of(clazz.cast(this.inventoryRetrievalParameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobDescription;
        private String action;
        private String archiveId;
        private String vaultARN;
        private String creationDate;
        private Boolean completed;
        private String statusCode;
        private String statusMessage;
        private Long archiveSizeInBytes;
        private Long inventorySizeInBytes;
        private String snsTopic;
        private String completionDate;
        private String sha256TreeHash;
        private String archiveSHA256TreeHash;
        private String retrievalByteRange;
        private String tier;
        private InventoryRetrievalJobDescription inventoryRetrievalParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            this.jobId(model.jobId);
            this.jobDescription(model.jobDescription);
            this.action(model.action);
            this.archiveId(model.archiveId);
            this.vaultARN(model.vaultARN);
            this.creationDate(model.creationDate);
            this.completed(model.completed);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.archiveSizeInBytes(model.archiveSizeInBytes);
            this.inventorySizeInBytes(model.inventorySizeInBytes);
            this.snsTopic(model.snsTopic);
            this.completionDate(model.completionDate);
            this.sha256TreeHash(model.sha256TreeHash);
            this.archiveSHA256TreeHash(model.archiveSHA256TreeHash);
            this.retrievalByteRange(model.retrievalByteRange);
            this.tier(model.tier);
            this.inventoryRetrievalParameters(model.inventoryRetrievalParameters);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobDescription() {
            return this.jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionCode action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getCompleted() {
            return this.completed;
        }

        @Override
        public final Builder completed(Boolean completed) {
            this.completed = completed;
            return this;
        }

        public final void setCompleted(Boolean completed) {
            this.completed = completed;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(StatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Long getArchiveSizeInBytes() {
            return this.archiveSizeInBytes;
        }

        @Override
        public final Builder archiveSizeInBytes(Long archiveSizeInBytes) {
            this.archiveSizeInBytes = archiveSizeInBytes;
            return this;
        }

        public final void setArchiveSizeInBytes(Long archiveSizeInBytes) {
            this.archiveSizeInBytes = archiveSizeInBytes;
        }

        public final Long getInventorySizeInBytes() {
            return this.inventorySizeInBytes;
        }

        @Override
        public final Builder inventorySizeInBytes(Long inventorySizeInBytes) {
            this.inventorySizeInBytes = inventorySizeInBytes;
            return this;
        }

        public final void setInventorySizeInBytes(Long inventorySizeInBytes) {
            this.inventorySizeInBytes = inventorySizeInBytes;
        }

        public final String getSNSTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSNSTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final String getCompletionDate() {
            return this.completionDate;
        }

        @Override
        public final Builder completionDate(String completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(String completionDate) {
            this.completionDate = completionDate;
        }

        public final String getSHA256TreeHash() {
            return this.sha256TreeHash;
        }

        @Override
        public final Builder sha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
            return this;
        }

        public final void setSHA256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
        }

        public final String getArchiveSHA256TreeHash() {
            return this.archiveSHA256TreeHash;
        }

        @Override
        public final Builder archiveSHA256TreeHash(String archiveSHA256TreeHash) {
            this.archiveSHA256TreeHash = archiveSHA256TreeHash;
            return this;
        }

        public final void setArchiveSHA256TreeHash(String archiveSHA256TreeHash) {
            this.archiveSHA256TreeHash = archiveSHA256TreeHash;
        }

        public final String getRetrievalByteRange() {
            return this.retrievalByteRange;
        }

        @Override
        public final Builder retrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
            return this;
        }

        public final void setRetrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
        }

        public final String getTier() {
            return this.tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final InventoryRetrievalJobDescription.Builder getInventoryRetrievalParameters() {
            return this.inventoryRetrievalParameters != null ? this.inventoryRetrievalParameters.toBuilder() : null;
        }

        @Override
        public final Builder inventoryRetrievalParameters(InventoryRetrievalJobDescription inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters;
            return this;
        }

        public final void setInventoryRetrievalParameters(InventoryRetrievalJobDescription.BuilderImpl inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters != null ? inventoryRetrievalParameters.build() : null;
        }

        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobResponse> {
        public Builder jobId(String var1);

        public Builder jobDescription(String var1);

        public Builder action(String var1);

        public Builder action(ActionCode var1);

        public Builder archiveId(String var1);

        public Builder vaultARN(String var1);

        public Builder creationDate(String var1);

        public Builder completed(Boolean var1);

        public Builder statusCode(String var1);

        public Builder statusCode(StatusCode var1);

        public Builder statusMessage(String var1);

        public Builder archiveSizeInBytes(Long var1);

        public Builder inventorySizeInBytes(Long var1);

        public Builder snsTopic(String var1);

        public Builder completionDate(String var1);

        public Builder sha256TreeHash(String var1);

        public Builder archiveSHA256TreeHash(String var1);

        public Builder retrievalByteRange(String var1);

        public Builder tier(String var1);

        public Builder inventoryRetrievalParameters(InventoryRetrievalJobDescription var1);

        default public Builder inventoryRetrievalParameters(Consumer<InventoryRetrievalJobDescription.Builder> inventoryRetrievalParameters) {
            return this.inventoryRetrievalParameters((InventoryRetrievalJobDescription)((InventoryRetrievalJobDescription.Builder)InventoryRetrievalJobDescription.builder().apply(inventoryRetrievalParameters)).build());
        }
    }
}

