/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.StreamingResponseHandler;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.AbortVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest;
import software.amazon.awssdk.services.glacier.model.AddTagsToVaultResponse;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.CompleteVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.CreateVaultRequest;
import software.amazon.awssdk.services.glacier.model.CreateVaultResponse;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.glacier.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.DeleteVaultRequest;
import software.amazon.awssdk.services.glacier.model.DeleteVaultResponse;
import software.amazon.awssdk.services.glacier.model.DescribeJobRequest;
import software.amazon.awssdk.services.glacier.model.DescribeJobResponse;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.model.DescribeVaultResponse;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetJobOutputRequest;
import software.amazon.awssdk.services.glacier.model.GetJobOutputResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.GlacierException;
import software.amazon.awssdk.services.glacier.model.InitiateJobRequest;
import software.amazon.awssdk.services.glacier.model.InitiateJobResponse;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest;
import software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse;
import software.amazon.awssdk.services.glacier.model.InsufficientCapacityException;
import software.amazon.awssdk.services.glacier.model.InvalidParameterValueException;
import software.amazon.awssdk.services.glacier.model.LimitExceededException;
import software.amazon.awssdk.services.glacier.model.ListJobsRequest;
import software.amazon.awssdk.services.glacier.model.ListJobsResponse;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.glacier.model.ListPartsRequest;
import software.amazon.awssdk.services.glacier.model.ListPartsResponse;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest;
import software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse;
import software.amazon.awssdk.services.glacier.model.ListVaultsRequest;
import software.amazon.awssdk.services.glacier.model.ListVaultsResponse;
import software.amazon.awssdk.services.glacier.model.MissingParameterValueException;
import software.amazon.awssdk.services.glacier.model.PolicyEnforcedException;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest;
import software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest;
import software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultResponse;
import software.amazon.awssdk.services.glacier.model.RequestTimeoutException;
import software.amazon.awssdk.services.glacier.model.ResourceNotFoundException;
import software.amazon.awssdk.services.glacier.model.ServiceUnavailableException;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyResponse;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest;
import software.amazon.awssdk.services.glacier.model.SetVaultNotificationsResponse;
import software.amazon.awssdk.services.glacier.model.UploadArchiveRequest;
import software.amazon.awssdk.services.glacier.model.UploadArchiveResponse;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse;
import software.amazon.awssdk.services.glacier.paginators.ListJobsPaginator;
import software.amazon.awssdk.services.glacier.paginators.ListMultipartUploadsPaginator;
import software.amazon.awssdk.services.glacier.paginators.ListPartsPaginator;
import software.amazon.awssdk.services.glacier.paginators.ListVaultsPaginator;
import software.amazon.awssdk.services.glacier.transform.AbortMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.AbortMultipartUploadResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.AbortVaultLockRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.AbortVaultLockResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.AddTagsToVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.AddTagsToVaultResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.CompleteMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.CompleteMultipartUploadResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.CompleteVaultLockRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.CompleteVaultLockResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.CreateVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.CreateVaultResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteArchiveRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteArchiveResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteVaultAccessPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteVaultNotificationsResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DeleteVaultResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DescribeJobResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.DescribeVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.DescribeVaultResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.GetDataRetrievalPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetDataRetrievalPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.GetJobOutputRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetJobOutputResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.GetVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetVaultAccessPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.GetVaultLockRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetVaultLockResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.GetVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.GetVaultNotificationsResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.InitiateJobRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.InitiateJobResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.InitiateMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.InitiateMultipartUploadResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.InitiateVaultLockRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.InitiateVaultLockResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListJobsResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.ListMultipartUploadsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListMultipartUploadsResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.ListPartsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListPartsResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.ListProvisionedCapacityRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListProvisionedCapacityResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.ListTagsForVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListTagsForVaultResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.ListVaultsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.ListVaultsResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.PurchaseProvisionedCapacityRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.PurchaseProvisionedCapacityResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.RemoveTagsFromVaultRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.RemoveTagsFromVaultResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.SetDataRetrievalPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.SetDataRetrievalPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.SetVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.SetVaultAccessPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.SetVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.SetVaultNotificationsResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.UploadArchiveRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.UploadArchiveResponseUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.UploadMultipartPartRequestMarshaller;
import software.amazon.awssdk.services.glacier.transform.UploadMultipartPartResponseUnmarshaller;

@SdkInternalApi
final class DefaultGlacierClient
implements GlacierClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultGlacierClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AbortMultipartUploadResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AbortMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)abortMultipartUploadRequest).withMarshaller((Marshaller)new AbortMultipartUploadRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AbortVaultLockResponse abortVaultLock(AbortVaultLockRequest abortVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AbortVaultLockResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AbortVaultLockResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)abortVaultLockRequest).withMarshaller((Marshaller)new AbortVaultLockRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AddTagsToVaultResponse addTagsToVault(AddTagsToVaultRequest addTagsToVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, LimitExceededException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsToVaultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddTagsToVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToVaultRequest).withMarshaller((Marshaller)new AddTagsToVaultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CompleteMultipartUploadResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CompleteMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)completeMultipartUploadRequest).withMarshaller((Marshaller)new CompleteMultipartUploadRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CompleteVaultLockResponse completeVaultLock(CompleteVaultLockRequest completeVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CompleteVaultLockResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CompleteVaultLockResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)completeVaultLockRequest).withMarshaller((Marshaller)new CompleteVaultLockRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateVaultResponse createVault(CreateVaultRequest createVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateVaultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createVaultRequest).withMarshaller((Marshaller)new CreateVaultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteArchiveResponse deleteArchive(DeleteArchiveRequest deleteArchiveRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteArchiveResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteArchiveResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteArchiveRequest).withMarshaller((Marshaller)new DeleteArchiveRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteVaultResponse deleteVault(DeleteVaultRequest deleteVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVaultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVaultRequest).withMarshaller((Marshaller)new DeleteVaultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteVaultAccessPolicyResponse deleteVaultAccessPolicy(DeleteVaultAccessPolicyRequest deleteVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVaultAccessPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteVaultAccessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVaultAccessPolicyRequest).withMarshaller((Marshaller)new DeleteVaultAccessPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteVaultNotificationsResponse deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVaultNotificationsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteVaultNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVaultNotificationsRequest).withMarshaller((Marshaller)new DeleteVaultNotificationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobRequest).withMarshaller((Marshaller)new DescribeJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeVaultResponse describeVault(DescribeVaultRequest describeVaultRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeVaultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVaultRequest).withMarshaller((Marshaller)new DescribeVaultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetDataRetrievalPolicyResponse getDataRetrievalPolicy(GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataRetrievalPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetDataRetrievalPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataRetrievalPolicyRequest).withMarshaller((Marshaller)new GetDataRetrievalPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public <ReturnT> ReturnT getJobOutput(GetJobOutputRequest getJobOutputRequest, StreamingResponseHandler<GetJobOutputResponse, ReturnT> streamingResponseHandler) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new GetJobOutputResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ReturnT)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobOutputRequest).withMarshaller((Marshaller)new GetJobOutputRequestMarshaller(this.protocolFactory)), streamingResponseHandler);
    }

    @Override
    public GetVaultAccessPolicyResponse getVaultAccessPolicy(GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVaultAccessPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetVaultAccessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVaultAccessPolicyRequest).withMarshaller((Marshaller)new GetVaultAccessPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetVaultLockResponse getVaultLock(GetVaultLockRequest getVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVaultLockResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetVaultLockResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVaultLockRequest).withMarshaller((Marshaller)new GetVaultLockRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetVaultNotificationsResponse getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVaultNotificationsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetVaultNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVaultNotificationsRequest).withMarshaller((Marshaller)new GetVaultNotificationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public InitiateJobResponse initiateJob(InitiateJobRequest initiateJobRequest) throws ResourceNotFoundException, PolicyEnforcedException, InvalidParameterValueException, MissingParameterValueException, InsufficientCapacityException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (InitiateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateJobRequest).withMarshaller((Marshaller)new InitiateJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public InitiateMultipartUploadResponse initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateMultipartUploadResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (InitiateMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateMultipartUploadRequest).withMarshaller((Marshaller)new InitiateMultipartUploadRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public InitiateVaultLockResponse initiateVaultLock(InitiateVaultLockRequest initiateVaultLockRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateVaultLockResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (InitiateVaultLockResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initiateVaultLockRequest).withMarshaller((Marshaller)new InitiateVaultLockRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobsRequest).withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListJobsPaginator listJobsIterable(ListJobsRequest listJobsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        return new ListJobsPaginator(this, listJobsRequest);
    }

    @Override
    public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMultipartUploadsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListMultipartUploadsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMultipartUploadsRequest).withMarshaller((Marshaller)new ListMultipartUploadsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListMultipartUploadsPaginator listMultipartUploadsIterable(ListMultipartUploadsRequest listMultipartUploadsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        return new ListMultipartUploadsPaginator(this, listMultipartUploadsRequest);
    }

    @Override
    public ListPartsResponse listParts(ListPartsRequest listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPartsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListPartsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPartsRequest).withMarshaller((Marshaller)new ListPartsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPartsPaginator listPartsIterable(ListPartsRequest listPartsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        return new ListPartsPaginator(this, listPartsRequest);
    }

    @Override
    public ListProvisionedCapacityResponse listProvisionedCapacity(ListProvisionedCapacityRequest listProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProvisionedCapacityResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListProvisionedCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProvisionedCapacityRequest).withMarshaller((Marshaller)new ListProvisionedCapacityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsForVaultResponse listTagsForVault(ListTagsForVaultRequest listTagsForVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForVaultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTagsForVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForVaultRequest).withMarshaller((Marshaller)new ListTagsForVaultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListVaultsResponse listVaults(ListVaultsRequest listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVaultsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListVaultsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVaultsRequest).withMarshaller((Marshaller)new ListVaultsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListVaultsPaginator listVaultsIterable(ListVaultsRequest listVaultsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        return new ListVaultsPaginator(this, listVaultsRequest);
    }

    @Override
    public PurchaseProvisionedCapacityResponse purchaseProvisionedCapacity(PurchaseProvisionedCapacityRequest purchaseProvisionedCapacityRequest) throws InvalidParameterValueException, MissingParameterValueException, LimitExceededException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PurchaseProvisionedCapacityResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PurchaseProvisionedCapacityResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)purchaseProvisionedCapacityRequest).withMarshaller((Marshaller)new PurchaseProvisionedCapacityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveTagsFromVaultResponse removeTagsFromVault(RemoveTagsFromVaultRequest removeTagsFromVaultRequest) throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTagsFromVaultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemoveTagsFromVaultResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromVaultRequest).withMarshaller((Marshaller)new RemoveTagsFromVaultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetDataRetrievalPolicyResponse setDataRetrievalPolicy(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetDataRetrievalPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetDataRetrievalPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setDataRetrievalPolicyRequest).withMarshaller((Marshaller)new SetDataRetrievalPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetVaultAccessPolicyResponse setVaultAccessPolicy(SetVaultAccessPolicyRequest setVaultAccessPolicyRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetVaultAccessPolicyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetVaultAccessPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setVaultAccessPolicyRequest).withMarshaller((Marshaller)new SetVaultAccessPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetVaultNotificationsResponse setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetVaultNotificationsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SetVaultNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setVaultNotificationsRequest).withMarshaller((Marshaller)new SetVaultNotificationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UploadArchiveResponse uploadArchive(UploadArchiveRequest uploadArchiveRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UploadArchiveResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UploadArchiveResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)uploadArchiveRequest).withMarshaller((Marshaller)new StreamingRequestMarshaller((Marshaller)new UploadArchiveRequestMarshaller(this.protocolFactory), requestBody)));
    }

    @Override
    public UploadMultipartPartResponse uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest, RequestBody requestBody) throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException, RequestTimeoutException, ServiceUnavailableException, SdkBaseException, SdkClientException, GlacierException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UploadMultipartPartResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UploadMultipartPartResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)uploadMultipartPartRequest).withMarshaller((Marshaller)new StreamingRequestMarshaller((Marshaller)new UploadMultipartPartRequestMarshaller(this.protocolFactory), requestBody)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(GlacierException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestTimeoutException").withModeledClass(RequestTimeoutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingParameterValueException").withModeledClass(MissingParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientCapacityException").withModeledClass(InsufficientCapacityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyEnforcedException").withModeledClass(PolicyEnforcedException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

