/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.UploadArchiveRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class UploadArchiveRequestModelMarshaller {
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> ARCHIVEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-archive-description").build();
    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-sha256-tree-hash").build();
    private static final MarshallingInfo<Long> CONTENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Content-Length").build();
    private static final UploadArchiveRequestModelMarshaller INSTANCE = new UploadArchiveRequestModelMarshaller();

    public static UploadArchiveRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UploadArchiveRequest uploadArchiveRequest, ProtocolMarshaller protocolMarshaller) {
        if (uploadArchiveRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)uploadArchiveRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)uploadArchiveRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)uploadArchiveRequest.archiveDescription(), ARCHIVEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)uploadArchiveRequest.checksum(), CHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)uploadArchiveRequest.contentLength(), CONTENTLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

