/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadArchiveRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UploadArchiveRequest> {
    private final String vaultName;
    private final String accountId;
    private final String archiveDescription;
    private final String checksum;
    private final Long contentLength;

    private UploadArchiveRequest(BuilderImpl builder) {
        this.vaultName = builder.vaultName;
        this.accountId = builder.accountId;
        this.archiveDescription = builder.archiveDescription;
        this.checksum = builder.checksum;
        this.contentLength = builder.contentLength;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String accountId() {
        return this.accountId;
    }

    public String archiveDescription() {
        return this.archiveDescription;
    }

    public String checksum() {
        return this.checksum;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.archiveDescription() == null ? 0 : this.archiveDescription().hashCode());
        hashCode = 31 * hashCode + (this.checksum() == null ? 0 : this.checksum().hashCode());
        hashCode = 31 * hashCode + (this.contentLength() == null ? 0 : this.contentLength().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadArchiveRequest)) {
            return false;
        }
        UploadArchiveRequest other = (UploadArchiveRequest)((Object)obj);
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.archiveDescription() == null ^ this.archiveDescription() == null) {
            return false;
        }
        if (other.archiveDescription() != null && !other.archiveDescription().equals(this.archiveDescription())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        if (other.contentLength() == null ^ this.contentLength() == null) {
            return false;
        }
        return other.contentLength() == null || other.contentLength().equals(this.contentLength());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.archiveDescription() != null) {
            sb.append("ArchiveDescription: ").append(this.archiveDescription()).append(",");
        }
        if (this.checksum() != null) {
            sb.append("Checksum: ").append(this.checksum()).append(",");
        }
        if (this.contentLength() != null) {
            sb.append("ContentLength: ").append(this.contentLength()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vaultName": {
                return Optional.of(clazz.cast(this.vaultName()));
            }
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "archiveDescription": {
                return Optional.of(clazz.cast(this.archiveDescription()));
            }
            case "checksum": {
                return Optional.of(clazz.cast(this.checksum()));
            }
            case "ContentLength": {
                return Optional.of(clazz.cast(this.contentLength()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String vaultName;
        private String accountId;
        private String archiveDescription;
        private String checksum;
        private Long contentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadArchiveRequest model) {
            this.vaultName(model.vaultName);
            this.accountId(model.accountId);
            this.archiveDescription(model.archiveDescription);
            this.checksum(model.checksum);
            this.contentLength(model.contentLength);
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getArchiveDescription() {
            return this.archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        public UploadArchiveRequest build() {
            return new UploadArchiveRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadArchiveRequest> {
        public Builder vaultName(String var1);

        public Builder accountId(String var1);

        public Builder archiveDescription(String var1);

        public Builder checksum(String var1);

        public Builder contentLength(Long var1);
    }
}

