/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.glacier.GlacierClient;
import software.amazon.awssdk.services.glacier.model.DescribeVaultRequest;
import software.amazon.awssdk.services.glacier.waiters.DescribeVaultFunction;
import software.amazon.awssdk.services.glacier.waiters.VaultExists;
import software.amazon.awssdk.services.glacier.waiters.VaultNotExists;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.HttpSuccessStatusAcceptor;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;
import software.amazon.awssdk.waiters.WaiterState;

public class GlacierClientWaiters {
    private final GlacierClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public GlacierClientWaiters(GlacierClient client) {
        this.client = client;
    }

    public Waiter<DescribeVaultRequest> vaultExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVaultFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new VaultExists.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(15), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVaultRequest> vaultNotExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVaultFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.RETRY), new VaultNotExists.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(15), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }
}

