/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.glacier.model.VaultNotificationConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetVaultNotificationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetVaultNotificationsRequest> {
    private final String accountId;
    private final String vaultName;
    private final VaultNotificationConfig vaultNotificationConfig;

    private SetVaultNotificationsRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.vaultNotificationConfig = builder.vaultNotificationConfig;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public VaultNotificationConfig vaultNotificationConfig() {
        return this.vaultNotificationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.vaultNotificationConfig() == null ? 0 : this.vaultNotificationConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetVaultNotificationsRequest)) {
            return false;
        }
        SetVaultNotificationsRequest other = (SetVaultNotificationsRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.vaultNotificationConfig() == null ^ this.vaultNotificationConfig() == null) {
            return false;
        }
        return other.vaultNotificationConfig() == null || other.vaultNotificationConfig().equals(this.vaultNotificationConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.vaultNotificationConfig() != null) {
            sb.append("VaultNotificationConfig: ").append(this.vaultNotificationConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private VaultNotificationConfig vaultNotificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SetVaultNotificationsRequest model) {
            this.setAccountId(model.accountId);
            this.setVaultName(model.vaultName);
            this.setVaultNotificationConfig(model.vaultNotificationConfig);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final VaultNotificationConfig getVaultNotificationConfig() {
            return this.vaultNotificationConfig;
        }

        @Override
        public final Builder vaultNotificationConfig(VaultNotificationConfig vaultNotificationConfig) {
            this.vaultNotificationConfig = vaultNotificationConfig;
            return this;
        }

        public final void setVaultNotificationConfig(VaultNotificationConfig vaultNotificationConfig) {
            this.vaultNotificationConfig = vaultNotificationConfig;
        }

        public SetVaultNotificationsRequest build() {
            return new SetVaultNotificationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetVaultNotificationsRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder vaultNotificationConfig(VaultNotificationConfig var1);
    }
}

