/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPartsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListPartsRequest> {
    private final String accountId;
    private final String vaultName;
    private final String uploadId;
    private final String marker;
    private final String limit;

    private ListPartsRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.uploadId = builder.uploadId;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String marker() {
        return this.marker;
    }

    public String limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.uploadId() == null ? 0 : this.uploadId().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsRequest)) {
            return false;
        }
        ListPartsRequest other = (ListPartsRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        return other.limit() == null || other.limit().equals(this.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String uploadId;
        private String marker;
        private String limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsRequest model) {
            this.setAccountId(model.accountId);
            this.setVaultName(model.vaultName);
            this.setUploadId(model.uploadId);
            this.setMarker(model.marker);
            this.setLimit(model.limit);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(String limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(String limit) {
            this.limit = limit;
        }

        public ListPartsRequest build() {
            return new ListPartsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPartsRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder uploadId(String var1);

        public Builder marker(String var1);

        public Builder limit(String var1);
    }
}

