/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListMultipartUploadsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListMultipartUploadsRequest> {
    private final String accountId;
    private final String vaultName;
    private final String limit;
    private final String uploadIdMarker;

    private ListMultipartUploadsRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.limit = builder.limit;
        this.uploadIdMarker = builder.uploadIdMarker;
    }

    public String accountId() {
        return this.accountId;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public String limit() {
        return this.limit;
    }

    public String uploadIdMarker() {
        return this.uploadIdMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.vaultName() == null ? 0 : this.vaultName().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.uploadIdMarker() == null ? 0 : this.uploadIdMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsRequest)) {
            return false;
        }
        ListMultipartUploadsRequest other = (ListMultipartUploadsRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.vaultName() == null ^ this.vaultName() == null) {
            return false;
        }
        if (other.vaultName() != null && !other.vaultName().equals(this.vaultName())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.uploadIdMarker() == null ^ this.uploadIdMarker() == null) {
            return false;
        }
        return other.uploadIdMarker() == null || other.uploadIdMarker().equals(this.uploadIdMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.vaultName() != null) {
            sb.append("VaultName: ").append(this.vaultName()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.uploadIdMarker() != null) {
            sb.append("UploadIdMarker: ").append(this.uploadIdMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String vaultName;
        private String limit;
        private String uploadIdMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsRequest model) {
            this.setAccountId(model.accountId);
            this.setVaultName(model.vaultName);
            this.setLimit(model.limit);
            this.setUploadIdMarker(model.uploadIdMarker);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getVaultName() {
            return this.vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        public final String getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(String limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(String limit) {
            this.limit = limit;
        }

        public final String getUploadIdMarker() {
            return this.uploadIdMarker;
        }

        @Override
        public final Builder uploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        public final void setUploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
        }

        public ListMultipartUploadsRequest build() {
            return new ListMultipartUploadsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListMultipartUploadsRequest> {
        public Builder accountId(String var1);

        public Builder vaultName(String var1);

        public Builder limit(String var1);

        public Builder uploadIdMarker(String var1);
    }
}

