/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.DataRetrievalPolicy;

@SdkInternalApi
public class DataRetrievalPolicyMarshaller {
    private static final MarshallingInfo<List> RULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rules").build();
    private static final DataRetrievalPolicyMarshaller INSTANCE = new DataRetrievalPolicyMarshaller();

    public static DataRetrievalPolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DataRetrievalPolicy dataRetrievalPolicy, ProtocolMarshaller protocolMarshaller) {
        if (dataRetrievalPolicy == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataRetrievalPolicy.rules(), RULES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

