/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.DataRetrievalRule;
import software.amazon.awssdk.services.glacier.model.DataRetrievalRulesListCopier;
import software.amazon.awssdk.services.glacier.transform.DataRetrievalPolicyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DataRetrievalPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, DataRetrievalPolicy> {
    private final List<DataRetrievalRule> rules;

    private DataRetrievalPolicy(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    public List<DataRetrievalRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataRetrievalPolicy)) {
            return false;
        }
        DataRetrievalPolicy other = (DataRetrievalPolicy)obj;
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataRetrievalPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DataRetrievalRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(DataRetrievalPolicy model) {
            this.setRules(model.rules);
        }

        public final Collection<DataRetrievalRule> getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(Collection<DataRetrievalRule> rules) {
            this.rules = DataRetrievalRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(DataRetrievalRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<DataRetrievalRule> rules) {
            this.rules = DataRetrievalRulesListCopier.copy(rules);
        }

        public DataRetrievalPolicy build() {
            return new DataRetrievalPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DataRetrievalPolicy> {
        public Builder rules(Collection<DataRetrievalRule> var1);

        public Builder rules(DataRetrievalRule ... var1);
    }
}

