/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class UploadMultipartPartRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<String> UPLOADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("uploadId").build();
    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-sha256-tree-hash").build();
    private static final MarshallingInfo<String> RANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Content-Range").build();
    private static final UploadMultipartPartRequestModelMarshaller instance = new UploadMultipartPartRequestModelMarshaller();

    public static UploadMultipartPartRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(UploadMultipartPartRequest uploadMultipartPartRequest, ProtocolMarshaller protocolMarshaller) {
        if (uploadMultipartPartRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.uploadId(), UPLOADID_BINDING);
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.checksum(), CHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.range(), RANGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

