/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UploadMultipartPartRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").isBinary(false).build();
    private static final MarshallingInfo<String> UPLOADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("uploadId").isBinary(false).build();
    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-sha256-tree-hash").isBinary(false).build();
    private static final MarshallingInfo<String> RANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Content-Range").isBinary(false).build();
    private static final UploadMultipartPartRequestModelMarshaller INSTANCE = new UploadMultipartPartRequestModelMarshaller();

    private UploadMultipartPartRequestModelMarshaller() {
    }

    public static UploadMultipartPartRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UploadMultipartPartRequest uploadMultipartPartRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)uploadMultipartPartRequest), (String)"uploadMultipartPartRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.uploadId(), UPLOADID_BINDING);
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.checksum(), CHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)uploadMultipartPartRequest.range(), RANGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

