/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SetDataRetrievalPolicyRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").isBinary(false).defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<StructuredPojo> POLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policy").isBinary(false).build();
    private static final SetDataRetrievalPolicyRequestModelMarshaller INSTANCE = new SetDataRetrievalPolicyRequestModelMarshaller();

    private SetDataRetrievalPolicyRequestModelMarshaller() {
    }

    public static SetDataRetrievalPolicyRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)setDataRetrievalPolicyRequest), (String)"setDataRetrievalPolicyRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)setDataRetrievalPolicyRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)setDataRetrievalPolicyRequest.policy(), POLICY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

