/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.SelectParameters;
import software.amazon.awssdk.services.glacier.transform.InputSerializationUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.OutputSerializationUnmarshaller;

public class SelectParametersUnmarshaller
implements Unmarshaller<SelectParameters, JsonUnmarshallerContext> {
    private static final SelectParametersUnmarshaller INSTANCE = new SelectParametersUnmarshaller();

    public SelectParameters unmarshall(JsonUnmarshallerContext context) throws Exception {
        SelectParameters.Builder selectParametersBuilder = SelectParameters.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("InputSerialization", targetDepth)) {
                    context.nextToken();
                    selectParametersBuilder.inputSerialization(InputSerializationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ExpressionType", targetDepth)) {
                    context.nextToken();
                    selectParametersBuilder.expressionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Expression", targetDepth)) {
                    context.nextToken();
                    selectParametersBuilder.expression((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputSerialization", targetDepth)) {
                    context.nextToken();
                    selectParametersBuilder.outputSerialization(OutputSerializationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SelectParameters)selectParametersBuilder.build();
    }

    public static SelectParametersUnmarshaller getInstance() {
        return INSTANCE;
    }
}

