/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.SelectParameters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SelectParametersMarshaller {
    private static final MarshallingInfo<StructuredPojo> INPUTSERIALIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSerialization").isBinary(false).build();
    private static final MarshallingInfo<String> EXPRESSIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionType").isBinary(false).build();
    private static final MarshallingInfo<String> EXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expression").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTSERIALIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputSerialization").isBinary(false).build();
    private static final SelectParametersMarshaller INSTANCE = new SelectParametersMarshaller();

    private SelectParametersMarshaller() {
    }

    public static SelectParametersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SelectParameters selectParameters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)selectParameters, (String)"selectParameters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)selectParameters.inputSerialization(), INPUTSERIALIZATION_BINDING);
            protocolMarshaller.marshall((Object)selectParameters.expressionTypeAsString(), EXPRESSIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)selectParameters.expression(), EXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)selectParameters.outputSerialization(), OUTPUTSERIALIZATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

