/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.S3Location;
import software.amazon.awssdk.services.glacier.transform.EncryptionUnmarshaller;
import software.amazon.awssdk.services.glacier.transform.GrantUnmarshaller;

public class S3LocationUnmarshaller
implements Unmarshaller<S3Location, JsonUnmarshallerContext> {
    private static final S3LocationUnmarshaller INSTANCE = new S3LocationUnmarshaller();

    public S3Location unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Location.Builder s3LocationBuilder = S3Location.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BucketName", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.bucketName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Prefix", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.prefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Encryption", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.encryption(EncryptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CannedACL", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.cannedACL((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AccessControlList", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.accessControlList(new ListUnmarshaller((Unmarshaller)GrantUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Tagging", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.tagging(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("UserMetadata", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.userMetadata(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("StorageClass", targetDepth)) {
                    context.nextToken();
                    s3LocationBuilder.storageClass((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3Location)s3LocationBuilder.build();
    }

    public static S3LocationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

