/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.S3Location;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3LocationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").isBinary(false).build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Prefix").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encryption").isBinary(false).build();
    private static final MarshallingInfo<String> CANNEDACL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CannedACL").isBinary(false).build();
    private static final MarshallingInfo<List> ACCESSCONTROLLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessControlList").isBinary(false).build();
    private static final MarshallingInfo<Map> TAGGING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tagging").isBinary(false).build();
    private static final MarshallingInfo<Map> USERMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserMetadata").isBinary(false).build();
    private static final MarshallingInfo<String> STORAGECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageClass").isBinary(false).build();
    private static final S3LocationMarshaller INSTANCE = new S3LocationMarshaller();

    private S3LocationMarshaller() {
    }

    public static S3LocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3Location s3Location, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3Location, (String)"s3Location");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3Location.bucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3Location.prefix(), PREFIX_BINDING);
            protocolMarshaller.marshall((Object)s3Location.encryption(), ENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)s3Location.cannedACLAsString(), CANNEDACL_BINDING);
            protocolMarshaller.marshall(s3Location.accessControlList(), ACCESSCONTROLLIST_BINDING);
            protocolMarshaller.marshall(s3Location.tagging(), TAGGING_BINDING);
            protocolMarshaller.marshall(s3Location.userMetadata(), USERMETADATA_BINDING);
            protocolMarshaller.marshall((Object)s3Location.storageClassAsString(), STORAGECLASS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

