/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.OutputSerialization;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputSerializationMarshaller {
    private static final MarshallingInfo<StructuredPojo> CSV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("csv").isBinary(false).build();
    private static final OutputSerializationMarshaller INSTANCE = new OutputSerializationMarshaller();

    private OutputSerializationMarshaller() {
    }

    public static OutputSerializationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputSerialization outputSerialization, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputSerialization, (String)"outputSerialization");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputSerialization.csv(), CSV_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

