/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.OutputLocation;
import software.amazon.awssdk.services.glacier.transform.S3LocationUnmarshaller;

public class OutputLocationUnmarshaller
implements Unmarshaller<OutputLocation, JsonUnmarshallerContext> {
    private static final OutputLocationUnmarshaller INSTANCE = new OutputLocationUnmarshaller();

    public OutputLocation unmarshall(JsonUnmarshallerContext context) throws Exception {
        OutputLocation.Builder outputLocationBuilder = OutputLocation.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3", targetDepth)) {
                    context.nextToken();
                    outputLocationBuilder.s3(S3LocationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (OutputLocation)outputLocationBuilder.build();
    }

    public static OutputLocationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

