/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.OutputLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputLocationMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3").isBinary(false).build();
    private static final OutputLocationMarshaller INSTANCE = new OutputLocationMarshaller();

    private OutputLocationMarshaller() {
    }

    public static OutputLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputLocation outputLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputLocation, (String)"outputLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputLocation.s3(), S3_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

