/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InventoryRetrievalJobInputMarshaller {
    private static final MarshallingInfo<String> STARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDate").isBinary(false).build();
    private static final MarshallingInfo<String> ENDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndDate").isBinary(false).build();
    private static final MarshallingInfo<String> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Marker").isBinary(false).build();
    private static final InventoryRetrievalJobInputMarshaller INSTANCE = new InventoryRetrievalJobInputMarshaller();

    private InventoryRetrievalJobInputMarshaller() {
    }

    public static InventoryRetrievalJobInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InventoryRetrievalJobInput inventoryRetrievalJobInput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inventoryRetrievalJobInput, (String)"inventoryRetrievalJobInput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inventoryRetrievalJobInput.startDate(), STARTDATE_BINDING);
            protocolMarshaller.marshall((Object)inventoryRetrievalJobInput.endDate(), ENDDATE_BINDING);
            protocolMarshaller.marshall((Object)inventoryRetrievalJobInput.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)inventoryRetrievalJobInput.marker(), MARKER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

