/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InventoryRetrievalJobDescriptionMarshaller {
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").isBinary(false).build();
    private static final MarshallingInfo<String> STARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDate").isBinary(false).build();
    private static final MarshallingInfo<String> ENDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndDate").isBinary(false).build();
    private static final MarshallingInfo<String> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Marker").isBinary(false).build();
    private static final InventoryRetrievalJobDescriptionMarshaller INSTANCE = new InventoryRetrievalJobDescriptionMarshaller();

    private InventoryRetrievalJobDescriptionMarshaller() {
    }

    public static InventoryRetrievalJobDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InventoryRetrievalJobDescription inventoryRetrievalJobDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inventoryRetrievalJobDescription, (String)"inventoryRetrievalJobDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inventoryRetrievalJobDescription.format(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)inventoryRetrievalJobDescription.startDate(), STARTDATE_BINDING);
            protocolMarshaller.marshall((Object)inventoryRetrievalJobDescription.endDate(), ENDDATE_BINDING);
            protocolMarshaller.marshall((Object)inventoryRetrievalJobDescription.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)inventoryRetrievalJobDescription.marker(), MARKER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

