/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.InputSerialization;
import software.amazon.awssdk.services.glacier.transform.CSVInputUnmarshaller;

public class InputSerializationUnmarshaller
implements Unmarshaller<InputSerialization, JsonUnmarshallerContext> {
    private static final InputSerializationUnmarshaller INSTANCE = new InputSerializationUnmarshaller();

    public InputSerialization unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputSerialization.Builder inputSerializationBuilder = InputSerialization.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("csv", targetDepth)) {
                    context.nextToken();
                    inputSerializationBuilder.csv(CSVInputUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InputSerialization)inputSerializationBuilder.build();
    }

    public static InputSerializationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

