/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.Grantee;

public class GranteeUnmarshaller
implements Unmarshaller<Grantee, JsonUnmarshallerContext> {
    private static final GranteeUnmarshaller INSTANCE = new GranteeUnmarshaller();

    public Grantee unmarshall(JsonUnmarshallerContext context) throws Exception {
        Grantee.Builder granteeBuilder = Grantee.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    granteeBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DisplayName", targetDepth)) {
                    context.nextToken();
                    granteeBuilder.displayName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("URI", targetDepth)) {
                    context.nextToken();
                    granteeBuilder.uri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ID", targetDepth)) {
                    context.nextToken();
                    granteeBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EmailAddress", targetDepth)) {
                    context.nextToken();
                    granteeBuilder.emailAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Grantee)granteeBuilder.build();
    }

    public static GranteeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

