/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.Grantee;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GranteeMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").isBinary(false).build();
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("URI").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ID").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailAddress").isBinary(false).build();
    private static final GranteeMarshaller INSTANCE = new GranteeMarshaller();

    private GranteeMarshaller() {
    }

    public static GranteeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Grantee grantee, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)grantee, (String)"grantee");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)grantee.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)grantee.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)grantee.uri(), URI_BINDING);
            protocolMarshaller.marshall((Object)grantee.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)grantee.emailAddress(), EMAILADDRESS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

