/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.Grant;
import software.amazon.awssdk.services.glacier.transform.GranteeUnmarshaller;

public class GrantUnmarshaller
implements Unmarshaller<Grant, JsonUnmarshallerContext> {
    private static final GrantUnmarshaller INSTANCE = new GrantUnmarshaller();

    public Grant unmarshall(JsonUnmarshallerContext context) throws Exception {
        Grant.Builder grantBuilder = Grant.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Grantee", targetDepth)) {
                    context.nextToken();
                    grantBuilder.grantee(GranteeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Permission", targetDepth)) {
                    context.nextToken();
                    grantBuilder.permission((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Grant)grantBuilder.build();
    }

    public static GrantUnmarshaller getInstance() {
        return INSTANCE;
    }
}

