/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.Grant;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GrantMarshaller {
    private static final MarshallingInfo<StructuredPojo> GRANTEE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Grantee").isBinary(false).build();
    private static final MarshallingInfo<String> PERMISSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Permission").isBinary(false).build();
    private static final GrantMarshaller INSTANCE = new GrantMarshaller();

    private GrantMarshaller() {
    }

    public static GrantMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Grant grant, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)grant, (String)"grant");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)grant.grantee(), GRANTEE_BINDING);
            protocolMarshaller.marshall((Object)grant.permissionAsString(), PERMISSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

