/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.Encryption;

public class EncryptionUnmarshaller
implements Unmarshaller<Encryption, JsonUnmarshallerContext> {
    private static final EncryptionUnmarshaller INSTANCE = new EncryptionUnmarshaller();

    public Encryption unmarshall(JsonUnmarshallerContext context) throws Exception {
        Encryption.Builder encryptionBuilder = Encryption.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("EncryptionType", targetDepth)) {
                    context.nextToken();
                    encryptionBuilder.encryptionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KMSKeyId", targetDepth)) {
                    context.nextToken();
                    encryptionBuilder.kmsKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KMSContext", targetDepth)) {
                    context.nextToken();
                    encryptionBuilder.kmsContext((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Encryption)encryptionBuilder.build();
    }

    public static EncryptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

