/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.Encryption;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EncryptionMarshaller {
    private static final MarshallingInfo<String> ENCRYPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionType").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KMSKeyId").isBinary(false).build();
    private static final MarshallingInfo<String> KMSCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KMSContext").isBinary(false).build();
    private static final EncryptionMarshaller INSTANCE = new EncryptionMarshaller();

    private EncryptionMarshaller() {
    }

    public static EncryptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Encryption encryption, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)encryption, (String)"encryption");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)encryption.encryptionTypeAsString(), ENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)encryption.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)encryption.kmsContext(), KMSCONTEXT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

