/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.CSVOutput;

public class CSVOutputUnmarshaller
implements Unmarshaller<CSVOutput, JsonUnmarshallerContext> {
    private static final CSVOutputUnmarshaller INSTANCE = new CSVOutputUnmarshaller();

    public CSVOutput unmarshall(JsonUnmarshallerContext context) throws Exception {
        CSVOutput.Builder csvOutputBuilder = CSVOutput.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("QuoteFields", targetDepth)) {
                    context.nextToken();
                    csvOutputBuilder.quoteFields((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("QuoteEscapeCharacter", targetDepth)) {
                    context.nextToken();
                    csvOutputBuilder.quoteEscapeCharacter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RecordDelimiter", targetDepth)) {
                    context.nextToken();
                    csvOutputBuilder.recordDelimiter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FieldDelimiter", targetDepth)) {
                    context.nextToken();
                    csvOutputBuilder.fieldDelimiter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("QuoteCharacter", targetDepth)) {
                    context.nextToken();
                    csvOutputBuilder.quoteCharacter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CSVOutput)csvOutputBuilder.build();
    }

    public static CSVOutputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

