/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.CSVOutput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CSVOutputMarshaller {
    private static final MarshallingInfo<String> QUOTEFIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteFields").isBinary(false).build();
    private static final MarshallingInfo<String> QUOTEESCAPECHARACTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteEscapeCharacter").isBinary(false).build();
    private static final MarshallingInfo<String> RECORDDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordDelimiter").isBinary(false).build();
    private static final MarshallingInfo<String> FIELDDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FieldDelimiter").isBinary(false).build();
    private static final MarshallingInfo<String> QUOTECHARACTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteCharacter").isBinary(false).build();
    private static final CSVOutputMarshaller INSTANCE = new CSVOutputMarshaller();

    private CSVOutputMarshaller() {
    }

    public static CSVOutputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CSVOutput csvOutput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)csvOutput, (String)"csvOutput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)csvOutput.quoteFieldsAsString(), QUOTEFIELDS_BINDING);
            protocolMarshaller.marshall((Object)csvOutput.quoteEscapeCharacter(), QUOTEESCAPECHARACTER_BINDING);
            protocolMarshaller.marshall((Object)csvOutput.recordDelimiter(), RECORDDELIMITER_BINDING);
            protocolMarshaller.marshall((Object)csvOutput.fieldDelimiter(), FIELDDELIMITER_BINDING);
            protocolMarshaller.marshall((Object)csvOutput.quoteCharacter(), QUOTECHARACTER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

