/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glacier.model.CSVInput;

public class CSVInputUnmarshaller
implements Unmarshaller<CSVInput, JsonUnmarshallerContext> {
    private static final CSVInputUnmarshaller INSTANCE = new CSVInputUnmarshaller();

    public CSVInput unmarshall(JsonUnmarshallerContext context) throws Exception {
        CSVInput.Builder csvInputBuilder = CSVInput.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("FileHeaderInfo", targetDepth)) {
                    context.nextToken();
                    csvInputBuilder.fileHeaderInfo((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Comments", targetDepth)) {
                    context.nextToken();
                    csvInputBuilder.comments((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("QuoteEscapeCharacter", targetDepth)) {
                    context.nextToken();
                    csvInputBuilder.quoteEscapeCharacter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RecordDelimiter", targetDepth)) {
                    context.nextToken();
                    csvInputBuilder.recordDelimiter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FieldDelimiter", targetDepth)) {
                    context.nextToken();
                    csvInputBuilder.fieldDelimiter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("QuoteCharacter", targetDepth)) {
                    context.nextToken();
                    csvInputBuilder.quoteCharacter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CSVInput)csvInputBuilder.build();
    }

    public static CSVInputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

