/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glacier.model.CSVInput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CSVInputMarshaller {
    private static final MarshallingInfo<String> FILEHEADERINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileHeaderInfo").isBinary(false).build();
    private static final MarshallingInfo<String> COMMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comments").isBinary(false).build();
    private static final MarshallingInfo<String> QUOTEESCAPECHARACTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteEscapeCharacter").isBinary(false).build();
    private static final MarshallingInfo<String> RECORDDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordDelimiter").isBinary(false).build();
    private static final MarshallingInfo<String> FIELDDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FieldDelimiter").isBinary(false).build();
    private static final MarshallingInfo<String> QUOTECHARACTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteCharacter").isBinary(false).build();
    private static final CSVInputMarshaller INSTANCE = new CSVInputMarshaller();

    private CSVInputMarshaller() {
    }

    public static CSVInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CSVInput csvInput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)csvInput, (String)"csvInput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)csvInput.fileHeaderInfoAsString(), FILEHEADERINFO_BINDING);
            protocolMarshaller.marshall((Object)csvInput.comments(), COMMENTS_BINDING);
            protocolMarshaller.marshall((Object)csvInput.quoteEscapeCharacter(), QUOTEESCAPECHARACTER_BINDING);
            protocolMarshaller.marshall((Object)csvInput.recordDelimiter(), RECORDDELIMITER_BINDING);
            protocolMarshaller.marshall((Object)csvInput.fieldDelimiter(), FIELDDELIMITER_BINDING);
            protocolMarshaller.marshall((Object)csvInput.quoteCharacter(), QUOTECHARACTER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

