/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadArchiveResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, UploadArchiveResponse> {
    private final String location;
    private final String checksum;
    private final String archiveId;

    private UploadArchiveResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.checksum = builder.checksum;
        this.archiveId = builder.archiveId;
    }

    public String location() {
        return this.location;
    }

    public String checksum() {
        return this.checksum;
    }

    public String archiveId() {
        return this.archiveId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadArchiveResponse)) {
            return false;
        }
        UploadArchiveResponse other = (UploadArchiveResponse)((Object)obj);
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.archiveId(), other.archiveId());
    }

    public String toString() {
        return ToString.builder((String)"UploadArchiveResponse").add("Location", (Object)this.location()).add("Checksum", (Object)this.checksum()).add("ArchiveId", (Object)this.archiveId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "archiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String location;
        private String checksum;
        private String archiveId;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadArchiveResponse model) {
            super(model);
            this.location(model.location);
            this.checksum(model.checksum);
            this.archiveId(model.archiveId);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public UploadArchiveResponse build() {
            return new UploadArchiveResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, UploadArchiveResponse> {
        public Builder location(String var1);

        public Builder checksum(String var1);

        public Builder archiveId(String var1);
    }
}

