/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.ExpressionType;
import software.amazon.awssdk.services.glacier.model.InputSerialization;
import software.amazon.awssdk.services.glacier.model.OutputSerialization;
import software.amazon.awssdk.services.glacier.transform.SelectParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelectParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, SelectParameters> {
    private final InputSerialization inputSerialization;
    private final String expressionType;
    private final String expression;
    private final OutputSerialization outputSerialization;

    private SelectParameters(BuilderImpl builder) {
        this.inputSerialization = builder.inputSerialization;
        this.expressionType = builder.expressionType;
        this.expression = builder.expression;
        this.outputSerialization = builder.outputSerialization;
    }

    public InputSerialization inputSerialization() {
        return this.inputSerialization;
    }

    public ExpressionType expressionType() {
        return ExpressionType.fromValue(this.expressionType);
    }

    public String expressionTypeAsString() {
        return this.expressionType;
    }

    public String expression() {
        return this.expression;
    }

    public OutputSerialization outputSerialization() {
        return this.outputSerialization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSerialization());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSerialization());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectParameters)) {
            return false;
        }
        SelectParameters other = (SelectParameters)obj;
        return Objects.equals(this.inputSerialization(), other.inputSerialization()) && Objects.equals(this.expressionTypeAsString(), other.expressionTypeAsString()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.outputSerialization(), other.outputSerialization());
    }

    public String toString() {
        return ToString.builder((String)"SelectParameters").add("InputSerialization", (Object)this.inputSerialization()).add("ExpressionType", (Object)this.expressionTypeAsString()).add("Expression", (Object)this.expression()).add("OutputSerialization", (Object)this.outputSerialization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputSerialization": {
                return Optional.ofNullable(clazz.cast(this.inputSerialization()));
            }
            case "ExpressionType": {
                return Optional.ofNullable(clazz.cast(this.expressionTypeAsString()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "OutputSerialization": {
                return Optional.ofNullable(clazz.cast(this.outputSerialization()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SelectParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private InputSerialization inputSerialization;
        private String expressionType;
        private String expression;
        private OutputSerialization outputSerialization;

        private BuilderImpl() {
        }

        private BuilderImpl(SelectParameters model) {
            this.inputSerialization(model.inputSerialization);
            this.expressionType(model.expressionType);
            this.expression(model.expression);
            this.outputSerialization(model.outputSerialization);
        }

        public final InputSerialization.Builder getInputSerialization() {
            return this.inputSerialization != null ? this.inputSerialization.toBuilder() : null;
        }

        @Override
        public final Builder inputSerialization(InputSerialization inputSerialization) {
            this.inputSerialization = inputSerialization;
            return this;
        }

        public final void setInputSerialization(InputSerialization.BuilderImpl inputSerialization) {
            this.inputSerialization = inputSerialization != null ? inputSerialization.build() : null;
        }

        public final String getExpressionType() {
            return this.expressionType;
        }

        @Override
        public final Builder expressionType(String expressionType) {
            this.expressionType = expressionType;
            return this;
        }

        @Override
        public final Builder expressionType(ExpressionType expressionType) {
            this.expressionType(expressionType.toString());
            return this;
        }

        public final void setExpressionType(String expressionType) {
            this.expressionType = expressionType;
        }

        public final String getExpression() {
            return this.expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        public final OutputSerialization.Builder getOutputSerialization() {
            return this.outputSerialization != null ? this.outputSerialization.toBuilder() : null;
        }

        @Override
        public final Builder outputSerialization(OutputSerialization outputSerialization) {
            this.outputSerialization = outputSerialization;
            return this;
        }

        public final void setOutputSerialization(OutputSerialization.BuilderImpl outputSerialization) {
            this.outputSerialization = outputSerialization != null ? outputSerialization.build() : null;
        }

        public SelectParameters build() {
            return new SelectParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SelectParameters> {
        public Builder inputSerialization(InputSerialization var1);

        default public Builder inputSerialization(Consumer<InputSerialization.Builder> inputSerialization) {
            return this.inputSerialization((InputSerialization)((InputSerialization.Builder)InputSerialization.builder().applyMutation(inputSerialization)).build());
        }

        public Builder expressionType(String var1);

        public Builder expressionType(ExpressionType var1);

        public Builder expression(String var1);

        public Builder outputSerialization(OutputSerialization var1);

        default public Builder outputSerialization(Consumer<OutputSerialization.Builder> outputSerialization) {
            return this.outputSerialization((OutputSerialization)((OutputSerialization.Builder)OutputSerialization.builder().applyMutation(outputSerialization)).build());
        }
    }
}

