/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.glacier.model.AccessControlPolicyListCopier;
import software.amazon.awssdk.services.glacier.model.CannedACL;
import software.amazon.awssdk.services.glacier.model.Encryption;
import software.amazon.awssdk.services.glacier.model.Grant;
import software.amazon.awssdk.services.glacier.model.StorageClass;
import software.amazon.awssdk.services.glacier.model._hashmapCopier;
import software.amazon.awssdk.services.glacier.transform.S3LocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Location
implements StructuredPojo,
ToCopyableBuilder<Builder, S3Location> {
    private final String bucketName;
    private final String prefix;
    private final Encryption encryption;
    private final String cannedACL;
    private final List<Grant> accessControlList;
    private final Map<String, String> tagging;
    private final Map<String, String> userMetadata;
    private final String storageClass;

    private S3Location(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.encryption = builder.encryption;
        this.cannedACL = builder.cannedACL;
        this.accessControlList = builder.accessControlList;
        this.tagging = builder.tagging;
        this.userMetadata = builder.userMetadata;
        this.storageClass = builder.storageClass;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String prefix() {
        return this.prefix;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public CannedACL cannedACL() {
        return CannedACL.fromValue(this.cannedACL);
    }

    public String cannedACLAsString() {
        return this.cannedACL;
    }

    public List<Grant> accessControlList() {
        return this.accessControlList;
    }

    public Map<String, String> tagging() {
        return this.tagging;
    }

    public Map<String, String> userMetadata() {
        return this.userMetadata;
    }

    public StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public String storageClassAsString() {
        return this.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.cannedACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControlList());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagging());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.cannedACLAsString(), other.cannedACLAsString()) && Objects.equals(this.accessControlList(), other.accessControlList()) && Objects.equals(this.tagging(), other.tagging()) && Objects.equals(this.userMetadata(), other.userMetadata()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString());
    }

    public String toString() {
        return ToString.builder((String)"S3Location").add("BucketName", (Object)this.bucketName()).add("Prefix", (Object)this.prefix()).add("Encryption", (Object)this.encryption()).add("CannedACL", (Object)this.cannedACLAsString()).add("AccessControlList", this.accessControlList()).add("Tagging", this.tagging()).add("UserMetadata", this.userMetadata()).add("StorageClass", (Object)this.storageClassAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "CannedACL": {
                return Optional.ofNullable(clazz.cast(this.cannedACLAsString()));
            }
            case "AccessControlList": {
                return Optional.ofNullable(clazz.cast(this.accessControlList()));
            }
            case "Tagging": {
                return Optional.ofNullable(clazz.cast(this.tagging()));
            }
            case "UserMetadata": {
                return Optional.ofNullable(clazz.cast(this.userMetadata()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String prefix;
        private Encryption encryption;
        private String cannedACL;
        private List<Grant> accessControlList = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tagging = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();
        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            this.bucketName(model.bucketName);
            this.prefix(model.prefix);
            this.encryption(model.encryption);
            this.cannedACL(model.cannedACL);
            this.accessControlList(model.accessControlList);
            this.tagging(model.tagging);
            this.userMetadata(model.userMetadata);
            this.storageClass(model.storageClass);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getCannedACL() {
            return this.cannedACL;
        }

        @Override
        public final Builder cannedACL(String cannedACL) {
            this.cannedACL = cannedACL;
            return this;
        }

        @Override
        public final Builder cannedACL(CannedACL cannedACL) {
            this.cannedACL(cannedACL.toString());
            return this;
        }

        public final void setCannedACL(String cannedACL) {
            this.cannedACL = cannedACL;
        }

        public final Collection<Grant.Builder> getAccessControlList() {
            return this.accessControlList != null ? (Collection)this.accessControlList.stream().map(Grant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessControlList(Collection<Grant> accessControlList) {
            this.accessControlList = AccessControlPolicyListCopier.copy(accessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Grant ... accessControlList) {
            this.accessControlList(Arrays.asList(accessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Consumer<Grant.Builder> ... accessControlList) {
            this.accessControlList(Stream.of(accessControlList).map(c -> (Grant)((Grant.Builder)Grant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessControlList(Collection<Grant.BuilderImpl> accessControlList) {
            this.accessControlList = AccessControlPolicyListCopier.copyFromBuilder(accessControlList);
        }

        public final Map<String, String> getTagging() {
            return this.tagging;
        }

        @Override
        public final Builder tagging(Map<String, String> tagging) {
            this.tagging = _hashmapCopier.copy(tagging);
            return this;
        }

        public final void setTagging(Map<String, String> tagging) {
            this.tagging = _hashmapCopier.copy(tagging);
        }

        public final Map<String, String> getUserMetadata() {
            return this.userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = _hashmapCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = _hashmapCopier.copy(userMetadata);
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public S3Location build() {
            return new S3Location(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Location> {
        public Builder bucketName(String var1);

        public Builder prefix(String var1);

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }

        public Builder cannedACL(String var1);

        public Builder cannedACL(CannedACL var1);

        public Builder accessControlList(Collection<Grant> var1);

        public Builder accessControlList(Grant ... var1);

        public Builder accessControlList(Consumer<Grant.Builder> ... var1);

        public Builder tagging(Map<String, String> var1);

        public Builder userMetadata(Map<String, String> var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);
    }
}

