/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.CSVOutput;
import software.amazon.awssdk.services.glacier.transform.OutputSerializationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputSerialization
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputSerialization> {
    private final CSVOutput csv;

    private OutputSerialization(BuilderImpl builder) {
        this.csv = builder.csv;
    }

    public CSVOutput csv() {
        return this.csv;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.csv());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSerialization)) {
            return false;
        }
        OutputSerialization other = (OutputSerialization)obj;
        return Objects.equals(this.csv(), other.csv());
    }

    public String toString() {
        return ToString.builder((String)"OutputSerialization").add("Csv", (Object)this.csv()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "csv": {
                return Optional.ofNullable(clazz.cast(this.csv()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputSerializationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private CSVOutput csv;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSerialization model) {
            this.csv(model.csv);
        }

        public final CSVOutput.Builder getCsv() {
            return this.csv != null ? this.csv.toBuilder() : null;
        }

        @Override
        public final Builder csv(CSVOutput csv) {
            this.csv = csv;
            return this;
        }

        public final void setCsv(CSVOutput.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        public OutputSerialization build() {
            return new OutputSerialization(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputSerialization> {
        public Builder csv(CSVOutput var1);

        default public Builder csv(Consumer<CSVOutput.Builder> csv) {
            return this.csv((CSVOutput)((CSVOutput.Builder)CSVOutput.builder().applyMutation(csv)).build());
        }
    }
}

