/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.S3Location;
import software.amazon.awssdk.services.glacier.transform.OutputLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputLocation> {
    private final S3Location s3;

    private OutputLocation(BuilderImpl builder) {
        this.s3 = builder.s3;
    }

    public S3Location s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputLocation)) {
            return false;
        }
        OutputLocation other = (OutputLocation)obj;
        return Objects.equals(this.s3(), other.s3());
    }

    public String toString() {
        return ToString.builder((String)"OutputLocation").add("S3", (Object)this.s3()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Location s3;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputLocation model) {
            this.s3(model.s3);
        }

        public final S3Location.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3Location s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3Location.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        public OutputLocation build() {
            return new OutputLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputLocation> {
        public Builder s3(S3Location var1);

        default public Builder s3(Consumer<S3Location.Builder> s3) {
            return this.s3((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3)).build());
        }
    }
}

