/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glacier.model.DescribeVaultOutput;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.services.glacier.model.VaultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVaultsResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, ListVaultsResponse> {
    private final List<DescribeVaultOutput> vaultList;
    private final String marker;

    private ListVaultsResponse(BuilderImpl builder) {
        super(builder);
        this.vaultList = builder.vaultList;
        this.marker = builder.marker;
    }

    public List<DescribeVaultOutput> vaultList() {
        return this.vaultList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultList());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVaultsResponse)) {
            return false;
        }
        ListVaultsResponse other = (ListVaultsResponse)((Object)obj);
        return Objects.equals(this.vaultList(), other.vaultList()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListVaultsResponse").add("VaultList", this.vaultList()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VaultList": {
                return Optional.ofNullable(clazz.cast(this.vaultList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private List<DescribeVaultOutput> vaultList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVaultsResponse model) {
            super(model);
            this.vaultList(model.vaultList);
            this.marker(model.marker);
        }

        public final Collection<DescribeVaultOutput.Builder> getVaultList() {
            return this.vaultList != null ? (Collection)this.vaultList.stream().map(DescribeVaultOutput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vaultList(Collection<DescribeVaultOutput> vaultList) {
            this.vaultList = VaultListCopier.copy(vaultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vaultList(DescribeVaultOutput ... vaultList) {
            this.vaultList(Arrays.asList(vaultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vaultList(Consumer<DescribeVaultOutput.Builder> ... vaultList) {
            this.vaultList(Stream.of(vaultList).map(c -> (DescribeVaultOutput)((DescribeVaultOutput.Builder)DescribeVaultOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVaultList(Collection<DescribeVaultOutput.BuilderImpl> vaultList) {
            this.vaultList = VaultListCopier.copyFromBuilder(vaultList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListVaultsResponse build() {
            return new ListVaultsResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, ListVaultsResponse> {
        public Builder vaultList(Collection<DescribeVaultOutput> var1);

        public Builder vaultList(DescribeVaultOutput ... var1);

        public Builder vaultList(Consumer<DescribeVaultOutput.Builder> ... var1);

        public Builder marker(String var1);
    }
}

