/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.CSVInput;
import software.amazon.awssdk.services.glacier.transform.InputSerializationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputSerialization
implements StructuredPojo,
ToCopyableBuilder<Builder, InputSerialization> {
    private final CSVInput csv;

    private InputSerialization(BuilderImpl builder) {
        this.csv = builder.csv;
    }

    public CSVInput csv() {
        return this.csv;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.csv());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSerialization)) {
            return false;
        }
        InputSerialization other = (InputSerialization)obj;
        return Objects.equals(this.csv(), other.csv());
    }

    public String toString() {
        return ToString.builder((String)"InputSerialization").add("Csv", (Object)this.csv()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "csv": {
                return Optional.ofNullable(clazz.cast(this.csv()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSerializationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private CSVInput csv;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSerialization model) {
            this.csv(model.csv);
        }

        public final CSVInput.Builder getCsv() {
            return this.csv != null ? this.csv.toBuilder() : null;
        }

        @Override
        public final Builder csv(CSVInput csv) {
            this.csv = csv;
            return this;
        }

        public final void setCsv(CSVInput.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        public InputSerialization build() {
            return new InputSerialization(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputSerialization> {
        public Builder csv(CSVInput var1);

        default public Builder csv(Consumer<CSVInput.Builder> csv) {
            return this.csv((CSVInput)((CSVInput.Builder)CSVInput.builder().applyMutation(csv)).build());
        }
    }
}

