/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.glacier.model.GlacierResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitiateJobResponse
extends GlacierResponse
implements ToCopyableBuilder<Builder, InitiateJobResponse> {
    private final String location;
    private final String jobId;
    private final String jobOutputPath;

    private InitiateJobResponse(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.jobId = builder.jobId;
        this.jobOutputPath = builder.jobOutputPath;
    }

    public String location() {
        return this.location;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobOutputPath() {
        return this.jobOutputPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOutputPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateJobResponse)) {
            return false;
        }
        InitiateJobResponse other = (InitiateJobResponse)((Object)obj);
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobOutputPath(), other.jobOutputPath());
    }

    public String toString() {
        return ToString.builder((String)"InitiateJobResponse").add("Location", (Object)this.location()).add("JobId", (Object)this.jobId()).add("JobOutputPath", (Object)this.jobOutputPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobOutputPath": {
                return Optional.ofNullable(clazz.cast(this.jobOutputPath()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlacierResponse.BuilderImpl
    implements Builder {
        private String location;
        private String jobId;
        private String jobOutputPath;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateJobResponse model) {
            super(model);
            this.location(model.location);
            this.jobId(model.jobId);
            this.jobOutputPath(model.jobOutputPath);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobOutputPath() {
            return this.jobOutputPath;
        }

        @Override
        public final Builder jobOutputPath(String jobOutputPath) {
            this.jobOutputPath = jobOutputPath;
            return this;
        }

        public final void setJobOutputPath(String jobOutputPath) {
            this.jobOutputPath = jobOutputPath;
        }

        @Override
        public InitiateJobResponse build() {
            return new InitiateJobResponse(this);
        }
    }

    public static interface Builder
    extends GlacierResponse.Builder,
    CopyableBuilder<Builder, InitiateJobResponse> {
        public Builder location(String var1);

        public Builder jobId(String var1);

        public Builder jobOutputPath(String var1);
    }
}

